<?php
defined('PF_VERSION') OR exit('Access denied');
?>
<div class="row">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Widgets','theme');?></h3></div>
            <div class="panel-body">
                <div class="row button-toolbar">
                    <div class="col-sm-6"></div>
                    <div class="col-sm-6">
                        <form action="<?php echo admin_url('pf_search=&action=index&page=')?>" method="post">
                            <div class="input-group">
								<?php echo form_input(array('name' => 'pf_search','placeholder' => __('Please enter the search conditions','theme')),$pf_search); ?>
								<span class="input-group-btn">
                                <button class="btn btn-default"
                                    type="submit">
                                    <i class="fa fa-search"></i> <?php echo __('Search','theme');?>
								</button> 
								<a class="btn btn-default" href="<?php echo admin_url('pf_search=&action=index&page=')?>">
                                    <i class="fa fa-times-circle"></i>
                                </a>
                                </span>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row" style="margin-bottom: 10px;">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9">
                        <!-- Pagination -->
    					<?php echo $pages->short_page_link();?>
    					<!-- Pagination -->
                    </div>
                </div>
                <table class="bootstrap-table">
                    <thead>
                        <tr>
                            <th data-fixed="left" style="width:30px;">#</th>
                            <th style="width:300px;"><?php echo __('Widget Name','theme');?></th>
                            <th style="width:90px;"><?php echo __('Version','theme');?></th>
                            <th><?php echo __('Description','theme');?></th>
                            <th style="width: 90px; text-align: center;"><?php echo __('Actions','theme');?></th>
                        </tr>
                    </thead>
                    <tbody>
						<?php if (!empty($widgets)){?>
						<?php $i=1; foreach ($widgets as $k => $widget){?>
						<tr>
						    <td style="text-align: center;"><?php echo ((int)$start + $i); $i++;?></td>
                            <td><?php echo htmlspecialchars($widget['name'])?></td>
                            <td><?php echo htmlspecialchars($widget['version'])?></td>
                            <td><?php echo htmlspecialchars($widget['description'])?></td>
                            <td style="text-align: center;">
                            <?php if (!in_array($k, $active_widgets)){?>
                                <a class="btn btn-primary btn-xs" href="<?php echo admin_url('action=activate&widget='.$k)?>"><?php echo __('Activate','theme');?></a>
                            <?php }else{ ?>
                                <a class="btn btn-danger btn-xs" href="<?php echo admin_url('action=deactivate&widget='.$k)?>"><?php echo __('Deactivate','theme');?></a>
                            <?php } ?>
                            </td>
                        </tr>
						<?php }?>
						<?php }?>
					</tbody>
                </table>
                
                
            </div>
             <div class="panel-footer">
                <div class="row">
                <div class="col-sm-6">
                    <?php echo $pages->page_lable(); ?>
                </div>
                <div class="col-sm-6">
                    <?php echo $pages->page_links(admin_url('pf_search='.$pf_search)."&"); ?>
               </div>
               </div>
             </div>
        </div>
    </div>
</div>
